﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.BL.APIMobile.Model
{
    public class GExerciseNote
    {
        private ZSBELearning.ContextParam ContextParam;

        /*
        on_start: [string, …], (notatki pokazywane przy starcie ćwiczenia)
        after_save: [string, …], (notatki po “sprawdź odpowiedzi”)
        after_solve: [string, …], (notatki po “pokaż prawidłowe”)
         */

        public GExerciseNote()
        {
            on_start = new List<string>();
            after_save = new List<string>();
            after_solve = new List<string>();
        }

        public GExerciseNote(ZSBELearning.ContextParam ContextParam) : this()
        {
            if ((ContextParam.AuxyliaryPages == BL.Dictionary.AuxyliaryPagesType.None) && (ContextParam.ExerciseOut != null))
            {
                XmlNodeList _notesList = ContextParam.ExerciseOut.XML.DocumentElement.SelectNodes(String.Format("{0}/{1}", GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Notes, GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Note));
             
                foreach(XmlNode _loopNotes in _notesList)
                {

                    if (Gemini.Utility.XML.Attribute.Get.Int(_loopNotes, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLAttributes.IsOnLoad, 0) == 1)
                    {
                        on_start.Add(Gemini.Utility.XML.Node.Get.CDATA(_loopNotes));
                    }

                    if (Gemini.Utility.XML.Attribute.Get.Int(_loopNotes, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLAttributes.IsOnCheck, 0) == 1)
                    {
                        after_save.Add(Gemini.Utility.XML.Node.Get.CDATA(_loopNotes));
                    }

                    if (Gemini.Utility.XML.Attribute.Get.Int(_loopNotes, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLAttributes.IsOnResolve, 0) == 1)
                    {
                        after_solve.Add(Gemini.Utility.XML.Node.Get.CDATA(_loopNotes));
                    }
                }
            }
        }

        public List<string> on_start { get; set; }
        public List<string> after_save { get; set; }
        public List<string> after_solve { get; set; }
    }
}
